c
c plane strain/ constant strain triangular element  3/11/1990, 2/3/1998
c
      program fem2d
c
c data in 'fem2d.dat'
c     (1) node,nel(2i5) : node = # of nodes     =< 64
c                         nel  = # of elements  =< 64
c     (2) ee,poi,h(3f10.0): ee   = Young-s modulus
c                           poi  = Poisson-s ratio
c                           h    = thickness
c     (3) x,y(2f10.0)   : x    = x-coordinate of a node
c                         y    = y-coordinate of a node
c         need 'node' sets of (3)
c     (4) i,j,k(3i5)    : i,j,k= node no. of an element
c                         (counter-clockwise)
c         need 'nel' sets of (4)
c     (5) ndis(i5)      : ndis = # of fixed-displacement(!) B.C.s
c     (6) j,k(2i5)      : j    = node no. of zero displacement B.C.
c                         k    = displ. component(1=x-dir, 2=y-dir)
c         need 'ndis' sets of (6)
c     (7) nforc(i5)     : nforc= # of given-force B.C.s
c     (8) j,k,ff(2i5,f10.0)
c                       : j    = node no. of given-force B.C.
c                       : k    = force component(1=x-dir, 2=y-dir)
c                       : ff   = its value
c         need 'nforc' sets of (8)
c
      implicit real*8 (a-h,o-z)
      character*1 dir(2)
      common / mem1  / s(128,128),f(128)
      common / mem2  / ind(128)
      common / base / alpha,beta,h,hh,poi,ee,cc(3,3)
      dimension sl(6,6),x(2,64),ntri(3,64)
      data dir / 'x', 'y' /
c
      nn0=128
      open(5,file='fem2d.dat')
      write(6,999)
c
c basic data input **************************************************
c
      read(5,500) node,nel
      nn=2*node
      call mater
      write(6,100) node,nel,ee,poi,h
      call coord (x,node)
      call nodel (ntri,nel)
c
      do 10 i=1,nn
      do 10 j=1,nn
      s(i,j)=0.d0
   10 continue
c
c local and global stiffness matrices *******************************
c
      do 20 i=1,nel
      call locals ( x(1,ntri(1,i)),x(1,ntri(2,i)),x(1,ntri(3,i)),sl )
      do 20 j=1,3
      j0=2*j-1
      jj=2*ntri(j,i)-1
      do 20 k=1,3
      k0=2*k-1
      kk=2*ntri(k,i)-1
      do 20 l=0,1
      do 20 m=0,1
      s(jj+l,kk+m)=s(jj+l,kk+m)+sl(j0+l,k0+m)
   20 continue
c
c fixed displacement boundary conditions ****************************
c
      read(5,500) ndis
      write(6,200) ndis
      do 30 i=1,ndis
      read(5,500) j,k
      write(6,300) dir(k),j
      m=2*j-2+k
      do 40 l=1,nn
      s(m,l)=0.d0
      s(l,m)=0.d0
   40 continue
      s(m,m)=1.d0
   30 continue
c
c lu decomposition
c
      call ludcmp(s,f,ind,nn,nn0)
c
      do 50 i=1,nn
      f(i)=0.d0
   50 continue
c
c force boundary conditions *****************************************
c
      read(5,500) nforc
      write(6,400) nforc
      do 60 i=1,nforc
      read(5,500) j,k,ff
      write(6,600) dir(k),j,ff
      m=2*j-2+k
      f(m)=ff
   60 continue
c
c solve it !! *******************************************************
c
      call lubksb(s,f,ind,nn,nn0)
c
c displacement output ***********************************************
c
      write(6,700)
      do 70 i=1,node
      j=2*i-1
      write(6,800) i,f(j)/ee,f(j+1)/ee
   70 continue
c
c stress/strain output
c
      write(6,900)
      do 80 i=1,nel
      i1=2*ntri(1,i)-1
      i2=2*ntri(2,i)-1
      i3=2*ntri(3,i)-1
      call stress ( x(1,ntri(1,i)),x(1,ntri(2,i)),x(1,ntri(3,i)),
     *              f(i1),f(i2),f(i3),i )
   80 continue
c                     ***********************************************
      close (5)
      stop
c
  100 format(/' ','# of nodes =',i5,' :',16x,'# of elements =',i5
     *       /' ','Young-s modulus =',1pd15.7,' , ',
     *       'Poisson-s ratio =',d15.7/' ',' with thickness =',d15.7/)
  200 format(/' ','# of fixed displacements =',i5)
  300 format(' ',5x,a1,'-component at node #',i5)
  400 format(/' ','# of given forces        =',i5)
  500 format(2i5,f10.0)
  600 format(' ',5x,a1,'-component at node #',i5,' : (value=',
     *       1pd15.7,' )')
  700 format(/' ','----- RESULTS OUTPUT -----'/
     *        ' ','Displacement:'/' ','  Node',5x,'x-dir',10x,'y-dir')
  800 format(' ',i5,1p2d15.7)
  900 format(/' ','Stress/Strain:'/' ','Element',4x,'Sxx',12x,'Syy',
     *            12x,'Sxy',10x,'Exx',6x,'Eyy',6x,'Exy')
  999 format(' ','FEM/plane strain problem/constant strain triangular',
     *           ' element/02-03-1998')
      end
c
      subroutine mater
c
c material parameters
c
      implicit real*8 (a-h,o-z)
      common / base / alpha,beta,h,hh,poi,ee,cc(3,3)
c
      read(5,100) ee,poi,h
c     h=1.d0
c
      alpha=1.d0-poi
      beta=(1.d0-2.d0*poi)/2.d0
      hh=(1.d0+poi)*(1.d0-2.d0*poi)
      cc(1,1)=alpha/hh
      cc(1,2)=poi/hh
      cc(1,3)=0.d0
      cc(2,1)=cc(1,2)
      cc(2,2)=cc(1,1)
      cc(2,3)=0.d0
      cc(3,1)=0.d0
      cc(3,2)=0.d0
      cc(3,3)=.5d0/(1.d0+poi)
      hh=h/4.d0/hh
      return
c
  100 format(3f10.0)
      end
c
      subroutine coord (x,node)
c
c node no. and its coordinates
c
      implicit real*8 (a-h,o-z)
      dimension x(2,64)
c
      do 10 i=1,node
      read(5,100) x0,y0
      write(6,200) i,x0,y0
      x(1,i)=x0
      x(2,i)=y0
   10 continue
      write(6,300)
      return
c
  100 format(2f10.0)
  200 format(' ','Node no.',i5,' :  x=',1pd15.7,'  y=',d15.7)
  300 format()
      end
c
      subroutine nodel (ntri,nel)
c
c node no. of one element
c
      dimension ntri(3,64)
      do 10 i=1,nel
      read(5,100) i1,i2,i3
      ntri(1,i)=i1
      ntri(2,i)=i2
      ntri(3,i)=i3
      write(6,200) i,i1,i2,i3
   10 continue
      return
c
  100 format(3i5)
  200 format(' ','Elmt no.',i5,' with corners at nodes :',3i5)
      end
c
      subroutine locals ( x1,x2,x3,sl )
c
c local stiffness matrix
c
      implicit real*8 (a-h,o-z)
      common / base / alpha,beta,h,hh,poi,ee,cc(3,3)
      dimension x1(2),x2(2),x3(2),sl(6,6)
c
      a1=x3(1)-x2(1)
      a2=x1(1)-x3(1)
      a3=x2(1)-x1(1)
      b1=x2(2)-x3(2)
      b2=x3(2)-x1(2)
      b3=x1(2)-x2(2)
      a=(a2*b1-a1*b2)/2.d0
      sl(1,1)=alpha*b1*b1+beta*a1*a1
      sl(1,2)=(poi+beta)*a1*b1
      sl(1,3)=alpha*b1*b2+beta*a1*a2
      sl(1,4)=poi*a2*b1+beta*a1*b2
      sl(1,5)=alpha*b1*b3+beta*a1*a3
      sl(1,6)=poi*a3*b1+beta*a1*b3
      sl(2,2)=alpha*a1*a1+beta*b1*b1
      sl(2,3)=poi*a1*b2+beta*a2*b1
      sl(2,4)=alpha*a1*a2+beta*b1*b2
      sl(2,5)=poi*a1*b3+beta*a3*b1
      sl(2,6)=alpha*a1*a3+beta*b1*b3
      sl(3,3)=alpha*b2*b2+beta*a2*a2
      sl(3,4)=(poi+beta)*a2*b2
      sl(3,5)=alpha*b2*b3+beta*a2*a3
      sl(3,6)=poi*a3*b2+beta*a2*b3
      sl(4,4)=alpha*a2*a2+beta*b2*b2
      sl(4,5)=poi*a2*b3+beta*a3*b2
      sl(4,6)=alpha*a2*a3+beta*b2*b3
      sl(5,5)=alpha*b3*b3+beta*a3*a3
      sl(5,6)=(poi+beta)*a3*b3
      sl(6,6)=alpha*a3*a3+beta*b3*b3
c
      do 10 i=1,6
      do 10 j=i,6
      sl(i,j)=sl(i,j)*hh/a
   10 continue
c
      do 20 i=1,5
      do 20 j=i+1,6
      sl(j,i)=sl(i,j)
   20 continue
c
      return
      end
c
      subroutine stress ( x1,x2,x3,d1,d2,d3,iel )
c
c stress/strain calculation
c
      implicit real*8 (a-h,o-z)
      common / base /alpha,beta,h,hh,poi,ee,cc(3,3)
      dimension x1(2),x2(2),x3(2),d1(2),d2(2),d3(2),q(3),s(3)
c
      a1=x3(1)-x2(1)
      a2=x1(1)-x3(1)
      a3=x2(1)-x1(1)
      b1=x2(2)-x3(2)
      b2=x3(2)-x1(2)
      b3=x1(2)-x2(2)
      a=(a2*b1-a1*b2)/2.d0
c
      q(1)=(b1*d1(1)+b2*d2(1)+b3*d3(1))/2.d0/a
      q(2)=(a1*d1(2)+a2*d2(2)+a3*d3(2))/2.d0/a
      q(3)=(a1*d1(1)+b1*d1(2)+a2*d2(1)+b2*d2(2)
     *      +a3*d3(1)+b3*d3(2))/2.d0/a
c
      do 10 i=1,3
      s(i)=0.d0
      do 10 j=1,3
      s(i)=s(i)+cc(i,j)*q(j)
   10 continue
c
      write(6,100) iel,s(1),s(2),s(3),q(1)/ee,q(2)/ee,q(3)/ee
c
      return
c
  100 format(' ',i5,1p3d15.7,3d9.1)
      end
c
      subroutine ludcmp (a,w,ind,n,n0)
c
c  from "NUMERICAL RECIPES" by W.H.Press et al.
c
c  for LU decomposition of matrix a(n,n)
c
      implicit real*8 (a-h,o-z)
      dimension a(n0,n),w(n),ind(n)
c                      w : working area
      data tiny / 1.d-20 /
c
      do 20 i=1,n
      aamax=0.d0
      do 10 j=1,n
      if( abs(a(i,j)).gt.aamax ) aamax=abs(a(i,j))
   10 continue
      if( aamax.eq.0.d0 ) stop
      w(i)=1.d0/aamax
   20 continue
      do 90 j=1,n
      do 40 i=1,j-1
      sum=a(i,j)
      do 30 k=1,i-1
      sum=sum-a(i,k)*a(k,j)
   30 continue
      a(i,j)=sum
   40 continue
      aamax=0.d0
      do 60 i=j,n
      sum=a(i,j)
      do 50 k=1,j-1
      sum=sum-a(i,k)*a(k,j)
   50 continue
      a(i,j)=sum
      dum=w(i)*abs(sum)
      if( dum.ge.aamax ) then
        imax=i
        aamax=dum
      endif
   60 continue
      if( j.ne.imax ) then
        do 70 k=1,n
        dum=a(imax,k)
        a(imax,k)=a(j,k)
        a(j,k)=dum
   70   continue
        w(imax)=w(j)
      endif
      ind(j)=imax
      if( a(j,j).eq.0.d0 ) a(j,j)=tiny
      if( j.ne.n ) then
        dum=1.d0/a(j,j)
        do 80 i=j+1,n
        a(i,j)=a(i,j)*dum
   80   continue
      endif
   90 continue
      return
      end
c
      subroutine lubksb (a,b,ind,n,n0)
c
c  from "NUMERICAL RECIPES" by W.H.Press et al.
c
c  to solve linear algebraic equation ax=b by LU decomposition
c     "x" will be stored in "b"
c
      implicit real*8 (a-h,o-z)
      dimension a(n0,n),b(n),ind(n)
      ii=0
      do 20 i=1,n
      ll=ind(i)
      sum=b(ll)
      b(ll)=b(i)
      if( ii.ne.0 ) then
        do 10 j=ii,i-1
        sum=sum-a(i,j)*b(j)
   10   continue
      else if( sum.ne.0.d0 ) then
        ii=i
      endif
      b(i)=sum
   20 continue
      do 40 i=n,1,-1
      sum=b(i)
      if( i.lt.n ) then
        do 30 j=i+1,n
        sum=sum-a(i,j)*b(j)
   30   continue
      endif
      b(i)=sum/a(i,i)
   40 continue
      return
      end
