c
c plane strain/ constant strain triangular element  3/11/1990, 2/3/1998
c  Nov/29/2005, Dec/16/2005, Jan/10/2006
c
      program fem2dsky
c
c  Skyline method is used to store non-symmetric matrix.
c   Elimination method is used to solve the simultaneous algebraic equation.
c    "Skyline algorithms for multilevel substructure analysis,"
c     by A.E.E. and D.W.M., Int.J.Numer.Meth.Eng., Vol.21, pp.465-479, 1985.
c
c data in 'fem2d.dat'
c
c     (1) node,nel,iterlast,maxbc(4i5)
c                       : node     = # of nodes
c                       : nel      = # of elements
c                       : iterlast = last # of iteration
c                       : maxbc    = max. # of BC's
c     (2) ee,poi(2f10.0): ee   = Young-s modulus
c                         poi  = Poisson-s ratio
c                           thickness h is set to be 1.
c         need '5' sets of (2); material number is from 1 to 5
c         stiffness matrix is normalized by ee(1)=ee0; ee(i) := ee(i)/ee0
c     (3) x,y(2f10.0)   : x    = x-coordinate of a node
c                         y    = y-coordinate of a node
c         need 'node' sets of (3)
c     (4) i,j,k,m(4i5)  : i,j,k= node no. of an element
c                         (counter-clockwise)
c                         m    = material number (1-5)
c         need 'nel' sets of (4)
c     (5) ndis(i5)      : ndis = # of given-displacement(!) B.C.s =<maxbc
c     (6) j,k,appld(2i5,f10.0)
c                       : j     = node no. of zero displacement B.C.
c                       : k     = displ. component(1=x-dir, 2=y-dir)
c                       : appld = its value
c         need 'ndis' sets of (6)
c     (7) nforc(i5)     : nforc= # of given-force B.C.s =<maxbc
c     (8) j,k,ff(2i5,f10.0)
c                       : j    = node no. of given-force B.C.
c                       : k    = force component(1=x-dir, 2=y-dir)
c                       : ff   = its value
c         need 'nforc' sets of (8)
c
c results in 'fem2d.out'
c
      implicit real*8 (a-h,o-z)
      parameter (maxa=16777216)
      parameter (maxia=16777216)
      parameter (maxstf=16777216)
c 128MB+64MB storage
      common / mem0 / a(maxa),ia(maxia)
c 256MB storage
      common / mem1 / stuh(maxstf),stlh(maxstf)
c
c MEMORY: When memory is short,
c         search a keyword 'MEMORY' and follow instructions;
c         totally 8 steps from MEMORY-1 throught MEMORY-8.
c         However it will need time at disk-I/O.
c
c 256MB storage
c  (MEMORY-1) Comment out the next line
      common / mem2 / stuho(maxstf),stlho(maxstf)
c
      open(5,file='fem2d.dat')
      open(6,file='fem2d.out')
      write(6,300)
c
c basic data input **************************************************
c
      read(5,100) node,nel,iterlast,maxbc
      write(6,200) node,nel,iterlast,maxbc
      nn=2*node
      nn1=nn+1
c
      ia1=1
      ia2=ia1+nel
      ia3=ia2+3*nel
      ia4=ia3+3*nel
      ia5=ia4+3*nel
      ia6=ia5+nn1
      ia7=ia6+nn
      ia8=ia7+maxbc
      ia9=ia8+maxbc-1
      if( ia9.gt.maxia ) then
        write(6,400) ia9,maxia,ia9
        stop
      endif
c
      iar1=1
      iar2=iar1+2*node
      iar3=iar2+nn
      iar4=iar3+nn
      iar5=iar4+4*nel
      iar6=iar5+4*nel
      iar7=iar6+nn
      iar8=iar7+maxbc
      iar9=iar8+maxbc
      iar10=iar9+4*nel-1
      if( iar10.gt.maxa ) then
        write(6,500) iar10,maxa,iar10
        stop
      endif
c
c material parameters
c
      call mater
c
c coordinate and nodal data
c
      call coord (a(iar1),node)
      call nodel (ia(ia1),ia(ia2),ia(ia3),ia(ia4),
     *              ia(ia5),ia(ia6),nel,node,nn,nn1,mlast)
c
      if( mlast.gt.maxstf ) then
        write(6,600) mlast,maxstf,mlast
        stop
      endif
c
c memory usage
c
      write(6,700) iar10,maxa,ia9,maxia,mlast,maxstf
c
      call fem2d (ia(ia1),ia(ia2),ia(ia3),ia(ia4),ia(ia5),ia(ia6),
     *            ia(ia7),ia(ia8),
     *            a(iar1),a(iar2),a(iar3),a(iar4),a(iar5),a(iar6),
     *            a(iar7),a(iar8),a(iar9),stuh,stlh,
c  (MEMORY-2) Comment out the next line
     *            stuho,stlho,
     *            node,nel,nn,nn1,maxbc,iterlast,mlast)
c
      stop
c
  100 format(4i5)
  200 format(/' ','# of nodes=',i5,':',16x,'# of elements=',i5/
     *        ' ','# of max iteration=',i5,':',10x,'# of max bc=',i5/)
  300 format(' ','FEM/ Plane Strain Problems/',
     *           ' Constant Strain Triangular Element/ Dec-16-2005')
  400 format(/' ','Size error of "ia"; ',i11,
     *            ' is greater than its limit ',i11,'!'/
     *    ' ','Increase "maxia" to ',i11,' in parameter statement.')
  500 format(/' ','Size error of "a"; ',i11,
     *            ' is greater than its limit ',i11,'!'/
     *    ' ','Increase "maxa" to ',i11,' in parameter statement.')
  600 format(/' ','Size error of "stuh etc."; ',i11,
     *            ' is greater than its limit ',i11,'!'/
     *    ' ','Increase "maxstf" to ',i11,' in parameter statement.')
  700 format(/' ','Memory (array) usage: "ia" is integer; ',
     *            'others are real*8;'/
     *        ' ',i11,' out of ',i11,' for "a,"'/
     *        ' ',i11,' out of ',i11,' for "ia,"'/
     *        ' ',i11,' out of ',i11,' for each "stuh" etc.')
c
      end
c
      subroutine fem2d (materl,ntri,isort,iosort,imx,msl,
     *                  mappld,mff,
     *                  x,temp,gdisp,gstre,geps,greact,
     *                  appld,ff,gepsp,stuh,stlh,
c  (MEMORY-3) Comment out the next line
     *                  stuho,stlho,
     *                  node,nel,nn,nn1,maxbc,iterlast,mlast)
      implicit real*8 (a-h,o-z)
      character*1 dir(2)
      common /base/ alpha(5),beta(5),h,hh(5),poi(5),ee(5),ee0,cc(5,3,3)
      dimension stuh(mlast),stlh(mlast)
c  (MEMORY-4) Comment out the next line
      dimension stuho(mlast),stlho(mlast)
      dimension x(2,node),materl(nel)
      dimension ntri(3,nel),isort(3,nel),iosort(3,nel)
      dimension imx(nn1),msl(nn),temp(nn)
      dimension gdisp(nn),gstre(4,nel)
      dimension geps(4,nel),greact(nn),gepsp(4,nel)
      dimension appld(maxbc),ff(maxbc),mappld(maxbc),mff(maxbc)
c
      data dir / 'x', 'y' /
c
      iter=0
c
c fixed displacement boundary conditions ****************************
c
      read(5,400) ndis
      write(6,200) ndis
      call dispbc (ndis,appld,mappld,dir)
c
c force boundary conditions *****************************************
c
      read(5,400) nforc
      write(6,300) nforc
      call forcbc (nforc,ff,mff,dir)
c
c input has been done here
c
      close (5)
c
c initialization of accumulated variables
c
      do 40 i=1,nn
        gdisp(i)=0.d0
        greact(i)=0.d0
   40 continue
      do 42 i=1,nel
        do 42 j=1,4
          gstre(j,i)=0.d0
          geps(j,i)=0.d0
          gepsp(j,i)=0.d0
   42 continue
c
c iteration starts here *********************************************
c
   50 continue
c
      iter=iter+1
      write(6,900) iter,iterlast
c
c clear stiffness and force vectors
c there are solutions if iterate in nonlinear problems, so clear them!
c
      do 10 i=1,mlast
        stuh(i)=0.d0
        stlh(i)=0.d0
   10 continue
c
c local and global stiffness matrices *******************************
c
      do 20 i=1,nel
        call locals (x(1,ntri(1,i)),x(1,ntri(2,i)),x(1,ntri(3,i)),
     *               materl(i),
     *               iosort(1,i),isort(1,i),imx,nn,stuh,stlh,mlast)
   20 continue
c
c remember original stiffness w/o boundary conditions for reaction
c
c  (MEMORY-5) Uncomment the next three lines
c      open(1,file='fem2d.tmp',form='unformatted')
c      write(1) stuh,stlh
c      close(1)
c  (MEMORY-6) and comment out the next four lines
      do 21 i=1,mlast
        stuho(i)=stuh(i)
        stlho(i)=stlh(i)
   21 continue
c
c force boundary conditions *****************************************
c
      do 60 i=1,nforc
        stlh(imx(mff(i)))=stlh(imx(mff(i)))+ff(i)
   60 continue
c
c displacement boundary conditions **********************************
c
      do 30 i=1,ndis
        call geobc (stuh,stlh,imx,msl,mappld(i),appld(i),nn,nn1,mlast)
   30 continue
c
c solve it !! *******************************************************
c
      call solve (stuh,stlh,imx,msl,det,idt,jdt,nn,mlast)
c
c determinant and its sign output ***********************************
c
      write(6,600) det,idt,jdt
c
c displacement output ***********************************************
c
      write(6,700)
      call dispout (stuh,stlh,imx,temp,gdisp,node,mlast,nn1,nn)
c
c stress/strain output
c
      write(6,800)
      do 80 i=1,nel
        i1=2*ntri(1,i)-1
        i2=2*ntri(2,i)-1
        i3=2*ntri(3,i)-1
        call stress (x(1,ntri(1,i)),x(1,ntri(2,i)),x(1,ntri(3,i)),
     *               materl(i),stlh(imx(i1)),stlh(imx(i1+1)),
     *                stlh(imx(i2)),stlh(imx(i2+1)),
     *                 stlh(imx(i3)),stlh(imx(i3+1)),i,
     *                  gstre(1,i),geps(1,i),gepsp(1,i))
   80 continue
c
c retrieve original stiffness w/o boundary conditions for reaction
c
c  (MEMORY-7) Uncomment the next three lines
c      open(1,file='fem2d.tmp',form='unformatted')
c      read(1) stuh,stlh
c      close(1)
c  (MEMORY-8) and comment out the next four lines
      do 81 i=1,mlast
        stuh(i)=stuho(i)
        stlh(i)=stlho(i)
   81 continue
c
      call reacfc (stuh,stlh,imx,temp,greact,node,nn1,nn,mlast,
     *                    mff,ff,nforc )
c
c one loop            ***********************************************
c
      if( iter.lt.iterlast ) go to 50
c
      write(6,999)
      close (6)
      return
c
  200 format(/' ','# of incremental/fixed displacements=',i5)
  300 format(/' ','# of incremental forces             =',i5)
  400 format(2i5,f10.0)
  600 format(/' ','Determinant =',1d15.7,' x10^(',i5,') [',i5,']')
  700 format(/' ','Displacement:'/' ','  Node',5x,'x-dir',10x,'y-dir')
  800 format(/' ','Stress and Strain:'/' ','Element',4x,'Sxx',8x,'Syy',
     *            8x,'Sxy',8x,'Szz',6x,'Exx',6x,'Eyy',6x,'Exy')
  900 format(/' ','----- Iteration ',i5,'/',i5,' ---------------')
  999 format(/' ','End Program -----------------------------------')
c
      end
c
      subroutine mater
c
c material parameters
c
      implicit real*8 (a-h,o-z)
      common /base/ alpha(5),beta(5),h,hh(5),poi(5),ee(5),ee0,cc(5,3,3)
c
c thickness is always ONE (cm? m? mm? depends on your definition)
      h=1.d0
c
      do 10 i=1,5
        read(5,100) ee(i),poi(i)
        write(6,200) i,ee(i),poi(i)
   10 continue
      ee0=ee(1)
      do 20 i=1,5
        ee(i)=ee(i)/ee0
        alpha(i)=1.d0-poi(i)
        beta(i)=(1.d0-2.d0*poi(i))/2.d0
        hh(i)=(1.d0+poi(i))*(1.d0-2.d0*poi(i))
        cc(i,1,1)=alpha(i)/hh(i)
        cc(i,1,2)=poi(i)/hh(i)
        cc(i,1,3)=0.d0
        cc(i,2,1)=cc(i,1,2)
        cc(i,2,2)=cc(i,1,1)
        cc(i,2,3)=0.d0
        cc(i,3,1)=0.d0
        cc(i,3,2)=0.d0
        cc(i,3,3)=.5d0/(1.d0+poi(i))
        hh(i)=h/4.d0/hh(i)*ee(i)
   20 continue
      write(6,300) h
      return
c
  100 format(2f10.0)
  200 format(' ','Mat #=',i5,', Young mdls=',1pd15.7,', ',
     *       'Poisson rt=',d15.7)
  300 format(/' ','     with thickness=',d15.7/)
c
      end
c
      subroutine coord (x,node)
c
c node no. and its coordinates
c
      implicit real*8 (a-h,o-z)
      dimension x(2,node)
c
      do 10 i=1,node
        read(5,100) x0,y0
        write(6,200) i,x0,y0
        x(1,i)=x0
        x(2,i)=y0
   10 continue
      write(6,300)
      return
c
  100 format(2f10.0)
  200 format(' ','Node #',i5,': x=',1pd15.7,', y=',d15.7)
  300 format(' ')
c
      end
c
      subroutine nodel (materl,ntri,isort,iosort,
     *                            imx,msl,nel,node,nn,nn1,mlast)
      implicit real*8 (a-h,o-z)
      dimension ntri(3,nel),isort(3,nel),iosort(3,nel)
      dimension imx(nn1),msl(nn),materl(nel)
c
c node no. of one element
c
      do 10 i=1,nel
        read(5,100) i1,i2,i3,materl(i)
        ntri(1,i)=i1
        ntri(2,i)=i2
        ntri(3,i)=i3
        write(6,200) i,i1,i2,i3,materl(i)
   10 continue
c
c  Sorting
c
      do 35 j=1,nel
        isort(1,j)=ntri(1,j)
        isort(2,j)=ntri(2,j)
        isort(3,j)=ntri(3,j)
        iosort(1,j)=1
        iosort(2,j)=2
        iosort(3,j)=3
c max: isort(1), min: isort(3), iosort():its order
        do 70 ij=1,2
        do 70 kl=ij+1,3
          if( isort(ij,j).lt.isort(kl,j) )then
            ijk=isort(ij,j)
            isort(ij,j)=isort(kl,j)
            isort(kl,j)=ijk
            ijk=iosort(ij,j)
            iosort(ij,j)=iosort(kl,j)
            iosort(kl,j)=ijk
          endif
   70   continue
   35 continue
c
c  Calculate column hight of the global tangential stiffness matrix
c
      do 20 i=1,nn1
        imx(i)=0
   20 continue
c
      do 90 i=2,node
c
        ii=node+2-i
        l=2*(ii-1)+1
c
        do 30 j=1,nel
          do 80 ij=1,2
            jj=isort(ij,j)
            if( ii.ne.jj ) go to 80
            k=iabs(jj-isort(3,j))
            if( imx(l).lt.k ) imx(l)=k
   80     continue
   30   continue
c
   90 continue
c
      do 40 i=1,node
        j=2*(i-1)+1
        imx(j)=2*imx(j)+1
        imx(j+1)=imx(j)+1
   40 continue
      imx(nn+1)=imx(nn-1)
c
c  position of diagonal elements in the skyline storage
c
      k=imx(1)
      do 50 i=2,nn1
        j=imx(i)
        imx(i)=imx(i-1)+k
        k=j
   50 continue
c
c  maximum size for the array of global stiffness
c
      mlast=imx(nn1)-1
c
c  row # of the upper end of column
c
      do 60 i=1,nn
        msl(i)=1+i+imx(i)-imx(i+1)
   60 continue
      return
c
  100 format(4i5)
  200 format(' ','Elmt #',i5,' with corners at nodes:',3i5,
     *           ' (Mat #',i5,')')
c
      end
c
      subroutine dispbc ( ndis,appld,mappld,dir )
      implicit real*8 (a-h,o-z)
      character*1 dir(2)
      dimension appld(ndis),mappld(ndis)
c
      do 10 i=1,ndis
        read(5,100) j,k,appld(i)
        write(6,200) dir(k),j,appld(i)
        mappld(i)=2*j-2+k
   10 continue
      return
c
  100 format(2i5,f10.0)
  200 format(' ',5x,a1,'-component at node #',i5,': (value=',
     *       1pd15.7,')')
c
      end
c
      subroutine forcbc ( nforc,ff,mff,dir )
      implicit real*8 (a-h,o-z)
      character*1 dir(2)
      dimension ff(nforc),mff(nforc)
c
      do 10 i=1,nforc
        read(5,100) j,k,ff(i)
        write(6,200) dir(k),j,ff(i)
        mff(i)=2*j-2+k
   10 continue
      return
c
  100 format(2i5,f10.0)
  200 format(' ',5x,a1,'-component at node #',i5,': (value=',
     *       1pd15.7,')')
c
      end
c
      subroutine locals ( x1,x2,x3,materl,
     *              iosort,isort,imx,nn,stuh,stlh,mlast )
      implicit real*8 (a-h,o-z)
      common /base/ alpha(5),beta(5),h,hh(5),poi(5),ee(5),ee0,cc(5,3,3)
      dimension x1(2),x2(2),x3(2),sl(6,6),slt(6,6)
      dimension iosort(3),isort(3),imx(nn),stuh(mlast),stlh(mlast)
c
c local stiffness matrix
c
      a1=x3(1)-x2(1)
      a2=x1(1)-x3(1)
      a3=x2(1)-x1(1)
      b1=x2(2)-x3(2)
      b2=x3(2)-x1(2)
      b3=x1(2)-x2(2)
      a=(a2*b1-a1*b2)/2.d0
      sl(1,1)=alpha(materl)*b1*b1+beta(materl)*a1*a1
      sl(1,2)=(poi(materl)+beta(materl))*a1*b1
      sl(1,3)=alpha(materl)*b1*b2+beta(materl)*a1*a2
      sl(1,4)=poi(materl)*a2*b1+beta(materl)*a1*b2
      sl(1,5)=alpha(materl)*b1*b3+beta(materl)*a1*a3
      sl(1,6)=poi(materl)*a3*b1+beta(materl)*a1*b3
      sl(2,2)=alpha(materl)*a1*a1+beta(materl)*b1*b1
      sl(2,3)=poi(materl)*a1*b2+beta(materl)*a2*b1
      sl(2,4)=alpha(materl)*a1*a2+beta(materl)*b1*b2
      sl(2,5)=poi(materl)*a1*b3+beta(materl)*a3*b1
      sl(2,6)=alpha(materl)*a1*a3+beta(materl)*b1*b3
      sl(3,3)=alpha(materl)*b2*b2+beta(materl)*a2*a2
      sl(3,4)=(poi(materl)+beta(materl))*a2*b2
      sl(3,5)=alpha(materl)*b2*b3+beta(materl)*a2*a3
      sl(3,6)=poi(materl)*a3*b2+beta(materl)*a2*b3
      sl(4,4)=alpha(materl)*a2*a2+beta(materl)*b2*b2
      sl(4,5)=poi(materl)*a2*b3+beta(materl)*a3*b2
      sl(4,6)=alpha(materl)*a2*a3+beta(materl)*b2*b3
      sl(5,5)=alpha(materl)*b3*b3+beta(materl)*a3*a3
      sl(5,6)=(poi(materl)+beta(materl))*a3*b3
      sl(6,6)=alpha(materl)*a3*a3+beta(materl)*b3*b3
c
      do 10 i=1,6
      do 10 j=i,6
        sl(i,j)=sl(i,j)*hh(materl)/a
   10 continue
c
      do 20 i=1,5
      do 20 j=i+1,6
        sl(j,i)=sl(i,j)
   20 continue
c
c rearrange in the order of node
c
      do 30 j=3,1,-1
        ij=2*(iosort(j)-1)+1
        kl=2*(3-j)+1
        do 30 m=3,1,-1
          mn=2*(iosort(m)-1)+1
          im=2*(3-m)+1
          slt(kl,im)=sl(ij,mn)
          slt(kl+1,im)=sl(ij+1,mn)
          slt(kl,im+1)=sl(ij,mn+1)
          slt(kl+1,im+1)=sl(ij+1,mn+1)
   30 continue
c
c put them into skyline storage
c
      i1=imx(2*(isort(3)-1)+1)
      i2=imx(2*isort(3))
      stuh(i1)=stuh(i1)+slt(1,1)
      stuh(i2)=stuh(i2)+slt(2,2)
      stuh(i2+1)=stuh(i2+1)+slt(1,2)
      stlh(i2+1)=stlh(i2+1)+slt(2,1)
c
      i1=imx(2*(isort(2)-1)+1)
      i2=imx(2*isort(2))
      i3=2*(isort(2)-isort(3))
      stuh(i1)=stuh(i1)+slt(3,3)
      stuh(i2)=stuh(i2)+slt(4,4)
      stuh(i2+1)=stuh(i2+1)+slt(3,4)
      stlh(i2+1)=stlh(i2+1)+slt(4,3)
      stuh(i1+i3)=stuh(i1+i3)+slt(1,3)
      stuh(i1+i3-1)=stuh(i1+i3-1)+slt(2,3)
      stuh(i2+i3)=stuh(i2+i3)+slt(2,4)
      stuh(i2+i3+1)=stuh(i2+i3+1)+slt(1,4)
      stlh(i1+i3)=stlh(i1+i3)+slt(3,1)
      stlh(i1+i3-1)=stlh(i1+i3-1)+slt(3,2)
      stlh(i2+i3)=stlh(i2+i3)+slt(4,2)
      stlh(i2+i3+1)=stlh(i2+i3+1)+slt(4,1)
c
      i1=imx(2*(isort(1)-1)+1)
      i2=imx(2*isort(1))
      i3=2*(isort(1)-isort(3))
      stuh(i1)=stuh(i1)+slt(5,5)
      stuh(i2)=stuh(i2)+slt(6,6)
      stuh(i2+1)=stuh(i2+1)+slt(5,6)
      stlh(i2+1)=stlh(i2+1)+slt(6,5)
      stuh(i1+i3)=stuh(i1+i3)+slt(1,5)
      stuh(i1+i3-1)=stuh(i1+i3-1)+slt(2,5)
      stuh(i2+i3)=stuh(i2+i3)+slt(2,6)
      stuh(i2+i3+1)=stuh(i2+i3+1)+slt(1,6)
      stlh(i1+i3)=stlh(i1+i3)+slt(5,1)
      stlh(i1+i3-1)=stlh(i1+i3-1)+slt(5,2)
      stlh(i2+i3)=stlh(i2+i3)+slt(6,2)
      stlh(i2+i3+1)=stlh(i2+i3+1)+slt(6,1)
c
      i3=2*(isort(1)-isort(2))
      stuh(i1+i3)=stuh(i1+i3)+slt(3,5)
      stuh(i1+i3-1)=stuh(i1+i3-1)+slt(4,5)
      stuh(i2+i3)=stuh(i2+i3)+slt(4,6)
      stuh(i2+i3+1)=stuh(i2+i3+1)+slt(3,6)
      stlh(i1+i3)=stlh(i1+i3)+slt(5,3)
      stlh(i1+i3-1)=stlh(i1+i3-1)+slt(5,4)
      stlh(i2+i3)=stlh(i2+i3)+slt(6,4)
      stlh(i2+i3+1)=stlh(i2+i3+1)+slt(6,3)
      return
c
      end
c
      subroutine geobc ( stuh,stlh,imx,msl,
     *                         mappld,appld,nn,nn1,mlast )
      implicit real*8 (a-h,o-z)
      common /base/ alpha(5),beta(5),h,hh(5),poi(5),ee(5),ee0,cc(5,3,3)
      dimension stuh(mlast),stlh(mlast),imx(nn1),msl(nn)
c                                  diagonal elements
      stlh(imx(mappld))=appld*ee0
      stuh(imx(mappld))=1.d0
      jst=imx(mappld)+1
      jed=imx(mappld+1)-1
c                                  off-diagonal elements
      if( jst.gt.jed ) go to 10
      do 20 ij=jst,jed
        stlh(imx(mappld+jst-ij-1))=
     *       stlh(imx(mappld+jst-ij-1))-appld*stuh(ij)*ee0
        stuh(ij)=0.d0
        stlh(ij)=0.d0
   20 continue
   10 continue
      jst=mappld+1
      do 30 ij=jst,nn
        if( msl(ij).gt.mappld ) go to 30
        jk=imx(ij)+ij-mappld
        stuh(jk)=0.d0
        stlh(imx(ij))=stlh(imx(ij))-appld*stlh(jk)*ee0
        stlh(jk)=0.d0
   30 continue
      return
c
      end
c
      subroutine dispout (stuh,stlh,imx,temp,gdisp,node,mlast,nn1,nn)
      implicit real*8 (a-h,o-z)
      common /base/ alpha(5),beta(5),h,hh(5),poi(5),ee(5),ee0,cc(5,3,3)
      dimension stuh(mlast),stlh(mlast)
      dimension imx(nn1),temp(nn),gdisp(nn)
c
      do 10 i=1,node
        j=2*i-1
        temp(j)=stlh(imx(j))
        temp(j+1)=stlh(imx(j+1))
        gdisp(j)=gdisp(j)+stlh(imx(j))
        gdisp(j+1)=gdisp(j+1)+stlh(imx(j+1))
        write(6,100) i,gdisp(j)/ee0,gdisp(j+1)/ee0
   10 continue
      return
c
  100 format(' ',i5,1p2d15.7)
c
      end
c
      subroutine stress ( x1,x2,x3,materl,d1x,d1y,d2x,d2y,d3x,d3y,
     *                       iel,gstre,geps,gepsp )
      implicit real*8 (a-h,o-z)
      common /base/ alpha(5),beta(5),h,hh(5),poi(5),ee(5),ee0,cc(5,3,3)
      dimension x1(2),x2(2),x3(2),q(3),s(3),gstre(4),geps(4),gepsp(4)
c
c stress/strain calculation
c
c     geps(1)=v1,1, geps(2)=v2,2, geps(3)=e12,
c                                       [=v1,2 geps(4)=v2,1 for future use]
c     gepsp(1)=ep^p_{11}, gepsp(2)=ep^p_{22}, gepsp(3)=ep^p_{12}
c                                       gepsp(4)=blank
c     plasticity not yet; gepsp(i)
c
      a1=x3(1)-x2(1)
      a2=x1(1)-x3(1)
      a3=x2(1)-x1(1)
      b1=x2(2)-x3(2)
      b2=x3(2)-x1(2)
      b3=x1(2)-x2(2)
      a=(a2*b1-a1*b2)/2.d0
c
      q(1)=(b1*d1x+b2*d2x+b3*d3x)/2.d0/a
      q(2)=(a1*d1y+a2*d2y+a3*d3y)/2.d0/a
      q(3)=(a1*d1x+b1*d1y+a2*d2x+b2*d2y
     *      +a3*d3x+b3*d3y)/2.d0/a
c
      do 10 i=1,3
        s(i)=0.d0
        geps(i)=geps(i)+q(i)
        do 10 j=1,3
          s(i)=s(i)+ee(materl)*cc(materl,i,j)*q(j)
   10 continue
      ss3=poi(materl)*(s(1)+s(2))
      geps(4)=geps(4)+0.d0
c
      gstre(1)=gstre(1)+s(1)
      gstre(2)=gstre(2)+s(2)
      gstre(3)=gstre(3)+s(3)
c     sigma_{33}
      gstre(4)=gstre(4)+ss3
c
      write(6,100) iel,gstre(1),gstre(2),gstre(3),gstre(4),
     *             geps(1)/ee0,geps(2)/ee0,geps(3)/ee0
      return
c
  100 format(' ',i5,1p4d11.3,3d9.1)
c
      end
c
      subroutine reacfc ( stuh,stlh,imx,temp,greact,node,nn1,nn,mlast,
     *                    mff,ff,nforc )
      implicit real*8 (a-h,o-z)
      dimension stuh(mlast),stlh(mlast),imx(nn1),temp(nn),greact(nn)
      dimension mff(nforc),ff(nforc)
c
      do 10 i=1,nn
        j1=imx(i+1)-imx(i)
        do 10 j=1,j1
          stlh(imx(i-j+1))=stlh(imx(i-j+1))+stuh(imx(i)+j-1)*temp(i)
   10 continue
      do 20 i=2,nn
        j1=imx(i+1)-imx(i)-1
        do 20 j=1,j1
          stlh(imx(i))=stlh(imx(i))+stlh(imx(i)+j)*temp(i-j)
   20 continue
      do 60 i=1,nforc
        stlh(imx(mff(i)))=stlh(imx(mff(i)))-ff(i)
   60 continue
      write(6,100)
      do 30 i=1,node
        j=2*i-1
        greact(j)=greact(j)+stlh(imx(j))
        greact(j+1)=greact(j+1)+stlh(imx(j+1))
        write(6,200) i,greact(j),greact(j+1)
   30 continue
      return
c
  100 format(/' ','Reaction Force:'/' ',
     *        '  Node',5x,'x-dir',10x,'y-dir')
  200 format(' ',i5,1p2d15.7)
c
      end
c
      subroutine solve ( stuh,stlh,imx,msl,det,idt,jdt,n0,mlast )
c
c ****************   R O U T I N E   T O   S O L V E   ***************
c
c  Elimination method
c
      implicit real*8 (a-h,o-z)
      dimension stuh(mlast),stlh(mlast)
      dimension imx(n0),msl(n0)
c
c  determinant = det D idt
c     jdt =  0 if all of determinants of partial matrix are positive
c         <> 0 otherwise
c
      det=stuh(1)
      idt=0
      jdt=0
      if( det.gt.0.d0 ) go to 80
      jdt=1
   80 continue
c
c  forward elimination
c
      do 10 j=2,n0
        ist=msl(j)+1
        ied=j-1
        if( ist.gt.ied ) go to 20
        do 30 i=ist,ied
          kst=msl(j)
          if( msl(i).gt.kst ) kst=msl(i)
          ked=i-1
          ij=imx(j)+j-i
          do 30 k=kst,ked
            kj=imx(j)+j-k
            ki=imx(i)+i-k
            stuh(ij)=stuh(ij)-stuh(kj)*stlh(ki)
            stlh(ij)=stlh(ij)-stlh(kj)*stuh(ki)
   30   continue
   20   continue
        do 40 i=msl(j),ied
          ij=imx(j)+j-i
          stuh(ij)=stuh(ij)/stuh(imx(i))
          stlh(ij)=stlh(ij)/stuh(imx(i))
   40   continue
        do 50 k=msl(j),ied
          kj=imx(j)+j-k
          stuh(imx(j))=stuh(imx(j))-stuh(kj)*stlh(kj)*stuh(imx(k))
          stlh(imx(j))=stlh(imx(j))-stlh(kj)*stlh(imx(k))
   50   continue
c
        if( j.eq.n0 ) go to 10
        if( stuh(imx(j)).gt.0.d0 ) go to 90
        jdt=jdt+1
   90   continue
        det=det*stuh(imx(j))
        jjjdt=idint(dlog10(dabs(det)))
        idt=idt+jjjdt
        det=det/10.d0**(jjjdt)
c
   10 continue
c
c  backward substitution
c
      do 60 j=1,n0
        stlh(imx(j))=stlh(imx(j))/stuh(imx(j))
   60 continue
      do 70 j=2,n0
        i=n0+2-j
        ked=i-1
        do 70 k=msl(i),ked
          ii=imx(i)+i-k
          stlh(imx(k))=stlh(imx(k))-stuh(ii)*stlh(imx(i))
   70 continue
      return
c
      end
